//-------------------------------------------------------------------------------------------------
// KS0108 low-level driver for PIC16 MCU (PICC Lite compiler)
// http://en.radzio.dxp.pl/ks0108/
// (c) Radosaw Kwiecie, radek@dxp.pl
//-------------------------------------------------------------------------------------------------
//#define _SUPPRESS_PLIB_WARNING 1
#include "KS0108-PIC16.h"
//#include "KS0108.h"
#include "delay.h"

void GLCD_Delay_EH(void)
{
asm("nop");
DelayUs(KS0108_EN_H);
}

void GLCD_Delay_EL(void)
{
asm("nop");
DelayUs(KS0108_EN_L);
}

//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
void GLCD_InitializePorts(void)
{
    KS0108_CLEAR_CS0;
    KS0108_CLEAR_CS1;
    KS0108_Write_RST;
    KS0108_Write_EN;
    KS0108_Write_CS1;
    KS0108_Write_CS0;
    KS0108_Write_RW;
    KS0108_Write_RS;
    KS0108_CLEAR_RESET;
}
//-------------------------------------------------------------------------------------------------
// Enable Controller (0-2)
//-------------------------------------------------------------------------------------------------
void GLCD_EnableController(unsigned char controller)
{
GLCD_Delay_EH();
switch(controller){
	case 0 : KS0108_ASSERT_CS0; break;
	case 1 : KS0108_ASSERT_CS1; break;
	}
GLCD_Delay_EH();
}
//-------------------------------------------------------------------------------------------------
// Disable Controller (0-2)
//-------------------------------------------------------------------------------------------------
void GLCD_DisableController(unsigned char controller)
{
GLCD_Delay_EL();
switch(controller){
	case 0 : KS0108_CLEAR_CS0; break;
	case 1 : KS0108_CLEAR_CS1; break;
	}
GLCD_Delay_EL();
}
//-------------------------------------------------------------------------------------------------
// Read Status from specified controller (0-2)
//-------------------------------------------------------------------------------------------------
unsigned char GLCD_ReadStatus(unsigned char controller)
{
unsigned char status;
KS0108_Read;
KS0108_ASSERT_RW;
KS0108_CLEAR_RS;
GLCD_EnableController(controller);
KS0108_ASSERT_ENABLE;
DelayUs(KS0108_EN_H);
KS0108_DATA_READ(status);
KS0108_CLEAR_ENABLE;
GLCD_DisableController(controller);
return status;
}
//-------------------------------------------------------------------------------------------------
// Write command to specified controller
//-------------------------------------------------------------------------------------------------
void GLCD_WriteCommand(unsigned char commandToWrite, unsigned char controller)
{
while(GLCD_ReadStatus(controller)&DISPLAY_STATUS_BUSY);
KS0108_Write;
KS0108_CLEAR_RW;
KS0108_CLEAR_RS;
GLCD_EnableController(controller);
KS0108_DATA_WRITE(commandToWrite);
KS0108_ASSERT_ENABLE;
GLCD_Delay_EL();
KS0108_CLEAR_ENABLE;
GLCD_DisableController(controller);
}
//-------------------------------------------------------------------------------------------------
// Read data from current position
//-------------------------------------------------------------------------------------------------
unsigned char GLCD_ReadData(void)
{
unsigned char data;
while(GLCD_ReadStatus(screen_x / 64)&DISPLAY_STATUS_BUSY);
KS0108_Read;
KS0108_ASSERT_RW;
KS0108_ASSERT_RS;
GLCD_EnableController(screen_x / 64);
KS0108_ASSERT_ENABLE;
KS0108_DATA_READ(data);
KS0108_CLEAR_ENABLE;
GLCD_DisableController(screen_x / 64);
screen_x++;
return data;
}
//-------------------------------------------------------------------------------------------------
// Write data to current position
//-------------------------------------------------------------------------------------------------
void GLCD_WriteData(unsigned char dataToWrite)
{
while(GLCD_ReadStatus(screen_x / 64)&DISPLAY_STATUS_BUSY);
KS0108_Write;
KS0108_CLEAR_RW;
KS0108_ASSERT_RS;
KS0108_DATA_WRITE(dataToWrite);
GLCD_EnableController(screen_x / 64);
KS0108_ASSERT_ENABLE;
GLCD_Delay_EL();
KS0108_CLEAR_ENABLE;
GLCD_DisableController(screen_x / 64);
screen_x++;
GLCD_Delay_EL();
}


//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
unsigned char GLCD_ReadByteFromROMMemory(char * ptr)
{
  return *(ptr);
}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------



